// JavaScript Document
function isAllNum(str)
{
	var dot_count = 0;
	for (var i=0; i<str.length; i++) 
	{
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.' ))
			continue;
		return false;
	}
	for(var i=0; i<str.length; i++)
	{
		if(str.charAt(i) == '.')
		{
			dot_count++;
		}
	}
	if(dot_count>3)
	{
		return false;
	}
	return true;
}
function isAllNum_port(str)
{
	
	for (var i=0; i<str.length; i++) 
	{
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') )
			continue;
		return false;
	}

	return true;
}
function checkRange(str, num, min, max)
{
	d = atoi(str, num);
	if (d > max || d < min)
		return false;
	return true;
}

function atoi(str, num)
{
	i = 1;
	if (num != 1) {
		while (i != num && str.length != 0) {
			if (str.charAt(0) == '.') {
				i++;
			}
			str = str.substring(1);
		}
		if (i != num)
			return -1;
	}

	for (i=0; i<str.length; i++) {
		if (str.charAt(i) == '.') {
			str = str.substring(0, i);
			break;
		}
	}
	if (str.length == 0)
		return -1;
	if((('0' == str.charAt(0)) && (1 != str.length)))
	    return -1;
	 	
	return parseInt(str, 10);
}

function hex(val)
{
	var h = (val-0).toString(16);
	if(h.length==1) h='0'+h;
	return h.toUpperCase();
}
function Op_AND_4Byte(v1, v2) {
	var i;
	var var1 = new Array();
	var var2 = new Array();
	var result='0x';

	for (i=2,j=0;i<10;i+=2,j++) {
		var1[j]='0x'+v1.substring(i,i+2);
		var2[j]='0x'+v2.substring(i,i+2);
	}
	
	for (i=0;i<4;i++) {
		result = result + hex(var1[i]&var2[i]);
	}
	
	result = result-0;
	return result;
}

function validateGateway(wanIp,netmaskIp,gatewayIp) {

	var i1,i2,i3, wip, nip, gip;
	var lan4, mask4, pool4, net_no, lo_broadcast;

	i1=wanIp.indexOf('.');
	i2=wanIp.indexOf('.',(i1+1));
	i3=wanIp.indexOf('.',(i2+1));
	wip = hex(wanIp.substring(0,i1)) + hex(wanIp.substring((i1+1),i2)) +hex(wanIp.substring((i2+1),i3))+hex(wanIp.substring((i3+1),wanIp.length));
	wip = '0x'+wip;
	lan4 = wanIp.substring((i3+1),wanIp.length)-0;
	
	i1=netmaskIp.indexOf('.');
	i2=netmaskIp.indexOf('.',(i1+1));
	i3=netmaskIp.indexOf('.',(i2+1));
	nip = hex(netmaskIp.substring(0,i1)) + hex(netmaskIp.substring((i1+1),i2)) +hex(netmaskIp.substring((i2+1),i3)) +hex(netmaskIp.substring((i3+1),netmaskIp.length));
	nip = '0x'+nip;
	mask4 = netmaskIp.substring((i3+1),netmaskIp.length)-0;

	i1=gatewayIp.indexOf('.');
	i2=gatewayIp.indexOf('.',(i1+1));
	i3=gatewayIp.indexOf('.',(i2+1));
	gip = hex(gatewayIp.substring(0,i1)) + hex(gatewayIp.substring((i1+1),i2)) +hex(gatewayIp.substring((i2+1),i3)) +hex(gatewayIp.substring((i3+1),gatewayIp.length));
	gip = '0x'+gip;
	pool4 = gatewayIp.substring((i3+1),gatewayIp.length)-0;
	
	if (Op_AND_4Byte(wip, nip) != Op_AND_4Byte(gip, nip))
	{
		//alert("Invalid Ip: " +gatewayIp+" not in " + wanIp+"/"+netmaskIp+" netmask");
		return false;
	}

	net_no = (lan4 & mask4);
	lo_broadcast =  (lan4 & mask4) + (255-mask4);
	
	if (pool4==net_no) {
		//alert("Invalid Ip: " +gatewayIp+" is the Network Number.");
		return false;
	}
	if (pool4==lo_broadcast) {
		//alert("Invalid Ip: " +gatewayIp+" is the Broadcast address.");
		return false;
	}
}

function validateStartEndIp(lan_ipaddr, netip, startip, endip)
{
	i1=startip.indexOf('.');
	i2=startip.indexOf('.',(i1+1));
	i3=startip.indexOf('.',(i2+1));
	sip = hex(startip.substring(0,i1)) + hex(startip.substring((i1+1),i2)) +hex(startip.substring((i2+1),i3))+hex(startip.substring((i3+1),startip.length));
	sip = '0x'+sip;

	i1=endip.indexOf('.');
	i2=endip.indexOf('.',(i1+1));
	i3=endip.indexOf('.',(i2+1));
	eip = hex(endip.substring(0,i1)) + hex(endip.substring((i1+1),i2)) +hex(endip.substring((i2+1),i3))+hex(endip.substring((i3+1),endip.length));
	eip = '0x'+eip;
	
	i1=lan_ipaddr.indexOf('.');
	i2=lan_ipaddr.indexOf('.',(i1+1));
	i3=lan_ipaddr.indexOf('.',(i2+1)); 
	lan_ipaddr = hex(lan_ipaddr.substring(0,i1)) + hex(lan_ipaddr.substring((i1+1),i2)) +hex(lan_ipaddr.substring((i2+1),i3))+hex(lan_ipaddr.substring((i3+1),lan_ipaddr.length));
	lan_ipaddr = '0x'+lan_ipaddr;

	if(sip>eip)
	{
		//alert("Invalid start and end IP address, end IP should be larger than start IP.");
		return 1;
	}
	
	if(lan_ipaddr >= sip && lan_ipaddr <= eip)
	{
	    return 2;
	}
	
	return 0;
}
function isNetmaskIPValid(ip)
{
	if (ip == 255 || ip == 254 || ip == 252 || ip == 248
	|| ip == 240 || ip == 224 || ip == 192 || ip == 128 || ip == 0)
	{
		return true;
	}
	else
	{
		return false;
	}
}

function checkIpAddr(field, ismask)
{
	if (field.value == "") {
		ShowError(field, Not_set_IP_addr[lang_index]);
		field.focus();
		return false;
	}

	if (isAllNum(field.value) == 0) {
		ShowError(field, IP_format_error[lang_index]);
		//field.value = field.defaultValue;
		field.focus();
		return false;
	}

	if (ismask) {
		if ((!checkRange(field.value, 1, 0, 256)) ||
				(!checkRange(field.value, 2, 0, 256)) ||
				(!checkRange(field.value, 3, 0, 256)) ||
				(!checkRange(field.value, 4, 0, 256)))
		{
			ShowError(field, ip_not_valid[lang_index]);
			field.focus();
			return false;
		}
	}
	else {
		if ((!checkRange(field.value, 1, 1, 223)) ||
				(!checkRange(field.value, 2, 0, 255)) ||
				(!checkRange(field.value, 3, 0, 255)) ||
				(!checkRange(field.value, 4, 1, 254)))
		{
			ShowError(field, ip_not_valid[lang_index]);
			//field.value = field.defaultValue;
			field.focus();
			return false;
		}
	}
	return true;
}

function check_specific_lan_ip(lan_ip)
{
	if(0 != lan_ip.indexOf('192.168.1.'))
	{
		return false;
	}
	return true;
}

function validateNetmask(netmask)
{
	var array = new Array();
	array = netmask.split(".");
	
	if (array.length != 4)
	{
		return false;
	}
	
	array[0] = parseInt(array[0]);
	array[1] = parseInt(array[1]);
	array[2] = parseInt(array[2]);
	array[3] = parseInt(array[3]);

	if (array[3] != 0)
	{
		if (array[2] != 255 || array[1] != 255 || array[0] != 255)
		{
			return false;
		}
		else
		{
			if (!isNetmaskIPValid(array[3]))
			{
				return false;
			}
		}
	}
	
	if (array[2] != 0)
	{
		if (array[1] != 255 || array[0] != 255)
		{
			return false;
		}
		else
		{
			if (!isNetmaskIPValid(array[2]))
			{
				return false;
			}
		}
	}
	
	if (array[1] != 0)
	{
		if (array[0] != 255)
		{
			return false;
		}
		else
		{
			if (!isNetmaskIPValid(array[1]))
			{
				return false;
			}
		}
	}
	
	return true;
}

function check_port_validity(src, dst, msg)
{
	if(parseInt(src.value)>parseInt(dst.value))
	{
		ShowError(src, msg+' port end must be bigger than '+msg+' port start');
		return false;
	}
	if(false==check_port_range(src, msg+' port start'))
	{
		return false;
	}
	if(false==check_port_range(dst, msg+' port end'))
	{
		return false;
	}
}
